package com.biz.crm.member.business.member.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/30 10:24
 * @description 小程序订单分页Dto
 */
@ApiModel(value = "AppOrderPaginationDto", description = "小程序订单分页Dto")
@Data
public class AppOrderPaginationDto {

  @ApiModelProperty("订单类型(虚拟订单数据字典:mms_app_dummy_order_status,枚举:AppDummyOrderStatusEnum)"
      + "、(实物订单数据字典:mms_app_real_order_status,枚举:AppRealOrderStatusEnum)")
  private String orderStatus;

  @ApiModelProperty("订单类型集合")
  private List<String> orderStatusList;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

}
