package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 *@description: 小程序积分商城兑换dto
*@Time:2023/7/5 16:12
*/
@Data
@ApiModel(value = "AppPointStoreDto",description = "小程序积分商城兑换dto")
public class AppPointStoreDto extends TenantFlagOpEntity {


  @ApiModelProperty("上架编码")
  private String code;

  @ApiModelProperty("上架名称")
  private String name;

  @ApiModelProperty("来源")
  private String source;

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("商品类型(实物，虚拟)")
  private String productType;

  @ApiModelProperty("等级限制")
  private String levelCode;

  @ApiModelProperty("当前会员等级下的会员编码(小程序积分商城所用)")
  private List<String> belowMemberCodes;

  @ApiModelProperty("兑换的数量(小程序积分商城所用)")
  private String exchangeCount;

  @ApiModelProperty("当前登录账号")
  private String userName;

  @ApiModelProperty("兑换人信息")
  private List<AppPointStorePeopleDto> contacts;
}
