package com.biz.crm.member.business.member.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 名片商品Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 18:09
 **/
@Getter
@Setter
@ApiModel(value = "CardProductDto", description = "名片商品Dto")
public class CardProductDto extends TenantFlagOpDto {

    @ApiModelProperty("名片编码")
    private String code;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("产品文件id")
    private String fileId;

    @ApiModelProperty("产品文件名")
    private String fileName;

    @ApiModelProperty("产品详情文件id")
    private String productFileId;

    @ApiModelProperty("产品详情文件名")
    private String productFileName;
}
