package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 虚拟订单分页查询dto
 *
 * @author zouhs
 * @date 2023-06-14 15:00:12
 */
@Data
@ApiModel(value = "DummyOrderPaginationDto", description = "虚拟订单分页查询dto")
public class DummyOrderPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("订单状态,数据字典:mms_dummy_order_status,枚举:DummyOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

  @ApiModelProperty("核销人")
  private String writeOffName;

  @ApiModelProperty("关联客户名称")
  private String userName;

  @ApiModelProperty("下单时间开始")
  private String orderTimeStart;

  @ApiModelProperty("下单时间结束")
  private String orderTimeEnd;

  @ApiModelProperty("下单人手机号")
  private String orderPhone;

  @ApiModelProperty("商品名称")
  private String productName;

  public void setOrderTimeStart(String orderTimeStart) {
    if(orderTimeStart!=null&&!orderTimeStart.equals("")){
      this.orderTimeStart = orderTimeStart+" 00:00:00";
    }
  }

  public void setOrderTimeEnd(String orderTimeEnd) {
    if(orderTimeEnd!=null&&!orderTimeEnd.equals("")){
      this.orderTimeEnd = orderTimeEnd+" 23:59:59";
    }
  }
}

