package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.member.business.member.sdk.enums.HolidayTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 节日Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 17:17
 **/
@Getter
@Setter
@ApiModel(value = "HolidayDto", description = "节日Dto")
public class HolidayDto extends TenantFlagOpDto {

    @ApiModelProperty("节日编码")
    private String code;

    @ApiModelProperty("节日名称")
    private String name;

    @ApiModelProperty("节日类型")
    private String type;

    @ApiModelProperty("节日日期开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayStartDate;

    @ApiModelProperty("节日日期结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayEndDate;

    @ApiModelProperty("单个用户额外积分上限")
    private Integer extraIntegralTop;

    @ApiModelProperty("积分倍数配置")
    List<HolidayIntegralDto> integrals;


}
