package com.biz.crm.member.business.member.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 会员节日获取积分记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 12:05
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayIntegralRecordDto", description = "会员节日获取积分记录Dto")
public class HolidayIntegralRecordDto extends TenantFlagOpDto {

    @ApiModelProperty("节日编码")
    private String holidayCode;

    @ApiModelProperty("会员手机号")
    private String memberPhone;

    @ApiModelProperty("获取积分数量")
    private BigDecimal integralNum;

    @ApiModelProperty("获取渠道")
    private String channel;

    @ApiModelProperty("开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
}
