package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 9:57
 * @description 新增公众号资讯类型的资讯管理dto
 */
@ApiModel(value = "InfoManagePubDto", description = "新增公众号资讯类型的资讯管理dto")
@Data
public class InfoManagePubDto extends TenantFlagOpDto {
  @ApiModelProperty("序号")
  private Integer  serialNum;

  @ApiModelProperty("标题")
  private String infoTitle;

  @ApiModelProperty("开始时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date startTime;

  @ApiModelProperty("结束时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date endTime;

  @ApiModelProperty("资讯类型,数据字典:mms_info_manage_type,枚举:InfoTypeEnum")
  private String infoType;

  @ApiModelProperty("跳转链接")
  private String targetUrl;

  @ApiModelProperty("封面图")
  private String overPic;
}
