package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hupan
 * @date 2023/6/13 17:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LabelDetailDto", description = "标签管理Dto")
public class LabelDetailDto extends TenantFlagOpDto {

  @ApiModelProperty("标签名称")
  private String name;

  @ApiModelProperty("标签种类名称")
  private String categoryName;

  @ApiModelProperty("标签类型，0表示手动，1表示自动")
  private String type;

  @ApiModelProperty("最近签收天数")
  private Integer days;

  @ApiModelProperty("最低签收频次")
  private Integer signFrequencyMin;

  @ApiModelProperty("最高签收频次")
  private Integer signFrequencyMax;

  @ApiModelProperty("累计最低成长值")
  private Integer accumulateGrowthValueMin;

  @ApiModelProperty("累计最高成长值")
  private Integer accumulateGrowthValueMax;

  @ApiModelProperty("当前最低成长值")
  private Integer nowGrowthValueMin;

  @ApiModelProperty("当前最高成长值")
  private Integer nowGrowthValueMax;

  @ApiModelProperty("累计最低积分")
  private Integer accumulatePointsMin;

  @ApiModelProperty("累计最高积分")
  private Integer accumulatePointsMax;

  @ApiModelProperty("当前最低积分")
  private Integer nowPointsMin;

  @ApiModelProperty("当前最高积分")
  private Integer nowPointsMax;

  @ApiModelProperty("连续几年成为会员")
  private Integer continuousYear;

  @ApiModelProperty("权益名称")
  private String benefitName;

}
