package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会员权益关联表分页查询dto
 *
 * @author zouhs
 * @date 2023-06-20 15:08:19
 */
@Data
@ApiModel(value = "MemberInfoBenefitsPaginationDto", description = "会员权益关联表分页查询dto")
public class MemberInfoBenefitsPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("权益编码")
  private String benefitsCode;

  @ApiModelProperty("权益名称")
  private String benefitsName;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  private String benefitsType;

  @ApiModelProperty("兑换状态,数据字典:mms_member_info_benefits_exchange_status,枚举:MemberInfoBenefitsStatusEnum")
  private String exchangeStatus;

  @ApiModelProperty("会员权益类型,数据字典:mms_member_info_benefits_member_benefits_type,枚举:MemberInfoMemberBenefitsTypeEnum")
  private String memberBenefitsType;

}

