package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会员成长值变动记录分页查询dto
 *
 * @author zouhs
 * @date 2023-06-19 14:29:42
 */
@Data
@ApiModel(value = "MemberInfoGrowRecordPaginationDto", description = "会员成长值变动记录分页查询dto")
public class MemberInfoGrowRecordPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("会员ID")
  private String memberId;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("发放流水号")
  private String growCode;

  @ApiModelProperty("用户名称")
  private String memberName;

  @ApiModelProperty("用户手机号")
  private String memberPhone;

  @ApiModelProperty("发放时间开始")
  private String optTimeStart;

  @ApiModelProperty("发放时间结束")
  private String optTimeEnd;

  @ApiModelProperty("来源")
  private String source;

  public void setOptTimeStart(String optTimeStart) {
    if(optTimeStart!=null&&!optTimeStart.equals("")){
      this.optTimeStart = optTimeStart+" 00:00:00";
    }
  }

  public void setOptTimeEnd(String optTimeEnd) {
    if(optTimeEnd!=null&&!optTimeEnd.equals("")){
      this.optTimeEnd = optTimeEnd+" 23:59:59";
    }
  }

}

