package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 数据字典: mms_points_view_detail
 *
 * @author hupan
 * @date 2023/6/27 11:29
 */
@Data
@ApiModel(value = "MemberInfoGrowRecordPaginationAPIDto", description = "小程序会员成长值变动记录分页查询dto")
public class MemberInfoIntegralRecordPaginationAPIDto extends TenantFlagOpDto {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("类型,数据字典mms_points_view_detail,枚举类型PointsViewDetailAPIEnum")
  private String type;

  @ApiModelProperty("来源,如果选项为全部,就不要传值,数据字典:mms_member_integral_source,枚举:IntegralSourceEnum")
  private String source;

  @ApiModelProperty("不需要填值,不需要填值,不需要填值,不需要填值")
  private List<String> sources;
}
