package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import liquibase.pro.packaged.S;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员积分变动记录分页查询dto
 *
 * @author zouhs
 * @date 2023-06-19 14:38:19
 */
@Data
@ApiModel(value = "MemberInfoIntegralRecordPaginationDto", description = "会员积分变动记录分页查询dto")
public class MemberInfoIntegralRecordPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("用户手机号")
  private String memberPhone;

  @ApiModelProperty("会员ID")
  private String memberId;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("发放流水号")
  private String integralCode;

  @ApiModelProperty("发放时间开始")
  private String optTimeStart;

  @ApiModelProperty("发放时间结束")
  private String optTimeEnd;

  @ApiModelProperty("来源")
  private String source;

  public void setOptTimeStart(String optTimeStart) {
    if(optTimeStart!=null&&!optTimeStart.equals("")){
      this.optTimeStart = optTimeStart+" 00:00:00";
    }
  }

  public void setOptTimeEnd(String optTimeEnd) {
    if(optTimeEnd!=null&&!optTimeEnd.equals("")){
      this.optTimeEnd = optTimeEnd+" 23:59:59";
    }
  }
}

