package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会员签到表分页查询dto
 *
 * @author zouhs
 * @date 2023-06-27 13:44:24
 */
@Data
@ApiModel(value = "MemberInfoSignPaginationDto", description = "会员签到表分页查询dto")
public class MemberInfoSignPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("下单时间开始")
  private String signTimeStart;

  @ApiModelProperty("下单时间结束")
  private String signTimeEnd;

  public void setSignTimeStart(String signTimeStart) {
    if(signTimeStart!=null&&!signTimeStart.equals("")){
      this.signTimeStart = signTimeStart+" 00:00:00";
    }
  }

  public void setSignTimeEnd(String signTimeEnd) {
    if(signTimeEnd!=null&&!signTimeEnd.equals("")){
      this.signTimeEnd = signTimeEnd+" 23:59:59";
    }
  }

}

