package com.biz.crm.member.business.member.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * 签到查询请求VO
 * @author zouhs
 * @date 2023/6/27
 */
@Data
public class MemberSignQueryVo implements Serializable {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("签到开始时间")
  private String signTimeStart;

  @ApiModelProperty("签到结束时间")
  private String signTimeEnd;

  public void setSignTimeStart(String signTimeStart) {
    if(signTimeStart!=null&&!signTimeStart.equals("")){
      this.signTimeStart = signTimeStart+" 00:00:00";
    }
  }

  public void setSignTimeEnd(String signTimeEnd) {
    if(signTimeEnd!=null&&!signTimeEnd.equals("")){
      this.signTimeEnd = signTimeEnd+" 23:59:59";
    }
  }
}
