package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 消息弹窗管理dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 13:54
 **/
@Getter
@Setter
@ApiModel(value = "MessageManageDto", description = "消息弹窗管理dto")
public class MessageManageDto extends TenantFlagOpDto {

    @ApiModelProperty("消息管理编码")
    private String code;

    @ApiModelProperty("触发类型,数据字典:mms_trigger_type,枚举:TriggerTypeEnum")
    private String triggerType;

    @ApiModelProperty("触发类型名称")
    private String triggerTypeName;

    @ApiModelProperty("触发条件,数据字典:mms_trigger_condition,枚举:TriggerConditionEnum")
    private String triggerCondition;

    @ApiModelProperty("触发条件名称")
    private String triggerConditionName;

    @ApiModelProperty("节日编码")
    private String holidayCode;

    @ApiModelProperty("节日名称")
    private String holidayName;

    @ApiModelProperty("权重")
    private String triggerWeight;

    @ApiModelProperty("消息通知")
    private Boolean messageNotify = Boolean.FALSE;

    @ApiModelProperty("开屏弹窗通知")
    private Boolean popupNotify = Boolean.FALSE;

    @ApiModelProperty("消息通知")
    private MessageNotifyDto message;

    @ApiModelProperty("弹窗")
    private PopupNotifyDto popup;
}
