package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 弹窗通知Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 14:14
 **/
@Getter
@Setter
@ApiModel(value = "PopupNotifyDto", description = "弹窗通知Dto")
public class PopupNotifyDto extends TenantFlagOpDto {

    @ApiModelProperty("消息管理编码")
    private String messageCode;

    @ApiModelProperty("频次,数据字典:mms_frequency,枚举:MessageFrequencyEnum")
    private String frequency;

    @ApiModelProperty("频次名称")
    private String frequencyName;

    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty("跳转,数据字典:mms_skip_type,枚举:SkipTypeEnum")
    private String skipType;

    @ApiModelProperty("跳转")
    private String skipTypeName;

    @ApiModelProperty("跳转url")
    private String skipUrl;

    @ApiModelProperty("小程序id")
    private String appId;

    /** 文件名 */
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @ApiModelProperty("文件名")
    private String fileName;





}
