
package com.biz.crm.member.business.member.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 奖品Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:55
 **/
@Getter
@Setter
@ApiModel(value = "PrizeDto", description = "奖品Dto")
public class PrizeDto extends TenantFlagOpDto {

    @ApiModelProperty("奖品编码")
    private String code;

    @ApiModelProperty("奖品名称")
    private String prizeName;


    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeType;


    @ApiModelProperty("奖品类型名称")
    private String prizeTypeName = StringUtils.EMPTY;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("单位编码,数据字典:mms_prize_unit,枚举:PrizeUnitEnum")
    private String  unitCode;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("是否有库存")
    private String inventory;

    @ApiModelProperty("库存数量")
    private BigDecimal inventoryNum;

    @ApiModelProperty("领取有效期")
    private Integer receiveTimeLimit;

    @ApiModelProperty("使用有效期")
    private Integer virtualTimeLimit;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("文件名")
    private String fileName = StringUtils.EMPTY;

    @ApiModelProperty("商品详情")
    private String productDes;

    @ApiModelProperty("总数量")
    private BigDecimal totalNum = BigDecimal.ZERO;

    @ApiModelProperty("中奖数量")
    private BigDecimal putNumHit = BigDecimal.ZERO;

    @ApiModelProperty("中奖已过期")
    private BigDecimal expired = BigDecimal.ZERO;

    @ApiModelProperty("领取已过期")
    private BigDecimal expiredClaimed = BigDecimal.ZERO;

}
