package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 商品分类DTO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 16:18
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductCategoryDto", description = "商品分类信息dto")
public class ProductCategoryDto extends TenantFlagOpDto {


    @ApiModelProperty("分类编码")
    private String categoryCode;

    @ApiModelProperty("分类名称")
    private String categoryName;

    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex;
}
