package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 积分商城 商品信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:23
 **/
@Data
@ApiModel(value = "ProductDto",description = "商品dto")
public class ProductDto extends TenantFlagOpDto {

    @ApiModelProperty("上架编码")
    private String code;

    @ApiModelProperty("上架名称")
    private String name;

    @ApiModelProperty("来源 数据字典:mms_product_source,枚举:ProductSourceEnum")
    private String source;

    @ApiModelProperty("上下架状态 数据字典:mms_shelf_status,枚举:ShelfStatusEnum")
    private String status;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品类型 数据字典:mms_product_type,枚举:ProductTypeEnum")
    private String productType;

    @ApiModelProperty("计量单位")
    private String unitCode = StringUtils.EMPTY;

    @ApiModelProperty("计量单位名称")
    private String unitName;

    @ApiModelProperty("商品分类编码")
    private String productCategoryCode;

    @ApiModelProperty("商品分类名称")
    private String productCategoryName;

    @ApiModelProperty("商品详情")
    private String productDesc;

    @ApiModelProperty("商品兑换规则")
    ProductExchangeRuleDto rule;

    @ApiModelProperty("商品文件")
    List<ProductFileDto> files;

    @ApiModelProperty("轮播图文件")
    List<ProductFileDto> viewPagerFile;

    @ApiModelProperty("缩略图片文件")
    List<ProductFileDto> smallFile;

    @ApiModelProperty("缩略图片文件")
    List<ProductFileDto> productFile;

}
