package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;


/**
 * 商品轮播图dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:07
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductFileDto", description = "商品轮播图dto")
public class ProductFileDto extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    private String ShelfCode;

    /** 相对路径 */
    @ApiModelProperty("相对路径")
    private String relativePath = StringUtils.EMPTY;

    /** 文件名 */
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @ApiModelProperty("文件名")
    private String fileName;

    /** 图片类型 */
    @ApiModelProperty("图片类型")
    private String type;

    /** 是主图 */
    @ApiModelProperty("是主图")
    @JsonProperty(value = "mainImage")
    private Boolean mainImage = Boolean.FALSE;

    /**
     * 排序（按数字顺序排列）
     */
    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex = 1;
}
