package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 积分商城 商品信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:23
 **/
@Data
@ApiModel(value = "ProductPageDto",description = "商品分页查询dto")
public class ProductPageDto extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    private String code;

    @ApiModelProperty("上架名称")
    private String name;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("上下架状态")
    private String status;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品类型(实物，虚拟)")
    private String productType;

    @ApiModelProperty("计量单位")
    private String unitCode;

    @ApiModelProperty("计量单位名称")
    private String unitName;

    @ApiModelProperty("商品分类编码")
    private String productCategoryCode;

    @ApiModelProperty("商品分类名称")
    private String productCategoryName;

    @ApiModelProperty("等级限制")
    private String levelCode;

    @ApiModelProperty("是否只查询可兑商品")
    private String available;

    @ApiModelProperty("当前会员等级下的会员编码(小程序积分商城所用)")
    private List<String> belowMemberCodes;

    @ApiModelProperty("当前登录账号")
    private String userName;


}
