package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:40
 * @description 问卷Dto
 */
@ApiModel(value = "QuestionnaireDto", description = "问卷Dto")
@Data
public class QuestionnaireDto extends TenantFlagOpDto {
  @ApiModelProperty("问卷编码")
  private String code;

  @ApiModelProperty("问卷标题")
  private String title;

  @ApiModelProperty("参与问卷可获得积分")
  private BigDecimal obtainPoints;

  @ApiModelProperty("开始时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date startTime;

  @ApiModelProperty("结束时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date endTime;

  @ApiModelProperty("背景图片")
  private String backgroundPic;

  @ApiModelProperty("问卷说明")
  private String description;

  @ApiModelProperty("完成问卷提示")
  private String completeTips;
}
