package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 16:44
 * @description 问卷分页Dto
 */
@ApiModel(value = "QuestionnairePaginationDto", description = "问卷分页Dto")
@Data
public class QuestionnairePaginationDto extends TenantFlagOpDto {
  @ApiModelProperty("问卷编码")
  private String code;

  @ApiModelProperty("问卷名称")
  private String title;

  @ApiModelProperty("时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date betweenTime;

  @ApiModelProperty("状态")
  private String pubStatus;

  @ApiModelProperty("开始时间")
  private String startTime;

  @ApiModelProperty("结束时间")
  private String endTime;


}
