package com.biz.crm.member.business.member.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 15:10
 * @description 问卷题目配置
 */
@Data
@ApiModel(value = "QuestionnaireQuestionDto", description = "问卷题目配置Dto")
public class QuestionnaireQuestionDto extends TenantFlagOpDto {

  @ApiModelProperty("组件字段")
  private String field;

  @ApiModelProperty("提示语")
  private String placeholder;

  @ApiModelProperty("组件类型")
  private String type;

  @ApiModelProperty("是否必填")
  private Boolean required;

  @ApiModelProperty("默认值")
  private String defaultValue;

  @ApiModelProperty("排序(按数字顺序排序)")
  private Integer sortIndex;

  @ApiModelProperty("题目标题")
  private String title;

  @ApiModelProperty("多选/单选的json值")
  private String configJsonValue;

}
