package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 大转盘管理Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 10:42
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RaffleManageDto", description = "大转盘管理Dto")
public class RaffleManageDto extends TenantFlagOpDto {

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("背景图片id")
    private String backgroundFileId;

    @ApiModelProperty("背景图片名称")
    private String backgroundFileName = StringUtils.EMPTY;

    @ApiModelProperty("转盘图片id")
    private String fileId;

    @ApiModelProperty("转盘图片名称")
    private String fileName = StringUtils.EMPTY;

    @ApiModelProperty("开始按钮图片id")
    private String startButtonFileId;

    @ApiModelProperty("开始按钮图片名称")
    private String startButtonFileName = StringUtils.EMPTY;

    @ApiModelProperty("分割线图片id")
    private String cuttingLineFileId;

    @ApiModelProperty("分割线图片名称")
    private String cuttingLineFileName = StringUtils.EMPTY;

    @ApiModelProperty("活动开始时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("活动结束时间（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty("规则文案")
    private String ruleDes;

    @ApiModelProperty("基础配置")
    private List<RaffleBaseConfigDto> baseConfigs;

    @ApiModelProperty("奖品信息")
    private List<RafflePrizeDto> rafflePrizes;



}
