package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 大转盘奖品信息详情Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 15:21
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeDetailsDto", description = "大转盘奖品信息详情Dto")
public class RafflePrizeDetailsDto extends TenantFlagOpDto {

    @ApiModelProperty("大转盘奖项编码")
    private String code;

    @ApiModelProperty("奖品配置编码")
    private String rafflePrizeCode;

    @ApiModelProperty("大转盘编码")
    private String raffleCode;

    @ApiModelProperty("奖品等级编码")
    private String prizeLevel;

    @ApiModelProperty("奖品等级名称")
    private String prizeLevelName;

    @ApiModelProperty("奖品编码")
    private String prizeCode;

    @ApiModelProperty("奖品名称")
    private String prizeName;

    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeType;

    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeTypeName;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("是否有库存,数据字典:mms_is_inventory,枚举:PrizeInventoryEnum")
    private String inventory;

    @ApiModelProperty("展示名称")
    private String showName;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    private String unitCode;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("总价格")
    private BigDecimal totalPrice;

    @ApiModelProperty("投放总价值")
    private BigDecimal totalValue;

    @ApiModelProperty("投放份数")
    private BigDecimal putCopies;

    @ApiModelProperty("投放数量")
    private BigDecimal putNum;

    @ApiModelProperty("投放库存份数")
    private BigDecimal putInventoryCopies;

    @ApiModelProperty("投放库存数量")
    private BigDecimal putInventoryNum;

    @ApiModelProperty("概率")
    private BigDecimal prizeProb;

    @ApiModelProperty("可投放数量")
    private BigDecimal canPutNum;

    @ApiModelProperty("库存数量")
    private BigDecimal inventoryNum = BigDecimal.ZERO;

    @ApiModelProperty("使用有效期(天)")
    private Integer useValidate;

    @ApiModelProperty("领取有效期(天)")
    private Integer claimValidate;

    @ApiModelProperty("是否为选择的无库存奖励(奖品发完后选择为无库存奖品)")
    private Boolean prizeFlag;

}
