package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.util.List;

/**
 * 大转盘活动奖品信息Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:37
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeDto", description = "大转盘活动奖品信息Dto")
public class RafflePrizeDto extends TenantFlagOpDto {


    @ApiModelProperty("大转盘活动编码")
    private String raffleCode;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("会员等级编码")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    private String memberLevelName;

    @ApiModelProperty("奖品发完选择")
    private String prizeOverSelect;

    @ApiModelProperty("抽奖奖品池")
    private String prizePool;

    @ApiModelProperty("会员等级集合")
    List<RaffleMemberDto> memberLevels;

    @ApiModelProperty("会员等级json")
    private String memberLevelJson;

    @ApiModelProperty("奖品信息详情")
    private List<RafflePrizeDetailsDto> details;

}
