package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 虚拟实物订单分页查询dto
 *
 * @author zouhs
 * @date 2023-06-14 14:52:43
 */
@Data
@ApiModel(value = "RealAndDummyOrderPaginationDto", description = "虚拟实物订单分页查询dto")
public class RealAndDummyOrderPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("会员订单")
  private String memberCode;

  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("订单状态,数据字典:mms_real_order_status,枚举:RealOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("订单类型,数据字典:mms_real_order_type,枚举:RealOrderTypeEnum")
  private String orderType;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

  @ApiModelProperty("下单时间开始")
  private String orderTimeStart;

  @ApiModelProperty("下单时间结束")
  private String orderTimeEnd;

  @ApiModelProperty("快递单号")
  private String expressNum;

  @ApiModelProperty("商品名称")
  private String productName;

  public void setOrderTimeStart(String orderTimeStart) {
    if(orderTimeStart!=null&&!orderTimeStart.equals("")){
      this.orderTimeStart = orderTimeStart+" 00:00:00";
    }
  }

  public void setOrderTimeEnd(String orderTimeEnd) {
    if(orderTimeEnd!=null&&!orderTimeEnd.equals("")){
      this.orderTimeEnd = orderTimeEnd+" 23:59:59";
    }
  }
}

