package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 实物订单分页查询dto
 *
 * @author zouhs
 * @date 2023-06-14 14:52:43
 */
@Data
@ApiModel(value = "RealOrderPaginationDto", description = "实物订单分页查询dto")
public class RealOrderPaginationDto extends TenantFlagOpDto {
  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("订单状态,数据字典:mms_real_order_status,枚举:RealOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("订单类型,数据字典:mms_real_order_type,枚举:RealOrderTypeEnum")
  private String orderType;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

  @ApiModelProperty("下单时间开始")
  private String orderTimeStart;

  @ApiModelProperty("下单时间结束")
  private String orderTimeEnd;

  public void setOrderTimeStart(String orderTimeStart) {
    if(orderTimeStart!=null&&!orderTimeStart.equals("")){
      this.orderTimeStart = orderTimeStart+" 00:00:00";
    }
  }

  public void setOrderTimeEnd(String orderTimeEnd) {
    if(orderTimeEnd!=null&&!orderTimeEnd.equals("")){
      this.orderTimeEnd = orderTimeEnd+" 23:59:59";
    }
  }

  @ApiModelProperty("下单人姓名")
  private String orderName;

  @ApiModelProperty("下单人手机号")
  private String orderPhone;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("是否分发 Y-N")
  private String flagDistribute;

  @ApiModelProperty("办事处负责人")
  private String officeName;

  @ApiModelProperty("办事处负责人手机号")
  private String officePhone;

  @ApiModelProperty("业务员")
  private String salesmanName;

  @ApiModelProperty("业务员手机号")
  private String salesmanPhone;

  @ApiModelProperty("签收时间")
  private String receiptTimeStart;

  @ApiModelProperty("签收时间")
  private String receiptTimeEnd;

  public void setReceiptTimeStart(String receiptTimeStart) {
    if(receiptTimeStart!=null&&!receiptTimeStart.equals("")){
      this.receiptTimeStart = receiptTimeStart+" 00:00:00";
    }
  }

  public void setReceiptTimeEnd(String receiptTimeEnd) {
    if(receiptTimeEnd!=null&&!receiptTimeEnd.equals("")){
      this.receiptTimeEnd = receiptTimeEnd+" 23:59:59";
    }
  }

  @ApiModelProperty("收货人")
  private String receiptName;

  @ApiModelProperty("收货人手机号")
  private String receiptPhone;

  @ApiModelProperty("收货地址")
  private String receiptAddress;

  @ApiModelProperty("关联组织名称")
  private String orgName;
}

