package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 13:51
 */
@Data
@ApiModel(value = "TaskingAdvisorInviteRecordPaginationDto", description = "品鉴顾问邀请分页查询dto")
public class TaskingAdvisorInviteRecordPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty("品鉴顾问编码")
  private String tastingCode;

  @ApiModelProperty("品鉴顾问名称")
  private String tastingName;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员名称")
  private String memberName;

  @ApiModelProperty("会员手机号")
  @Column(name="member_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '会员手机号'")
  private String memberPhone;

  @ApiModelProperty("关联组织编码")
  private String linkOrgCode;

  @ApiModelProperty("关联组织")
  private String linkOrgName;

  @ApiModelProperty("品鉴顾问手机号")
  private String tastingPhone;

  @ApiModelProperty("注册时间开始")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegisterStart;

  @ApiModelProperty("注册时间结束")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegisterEnd;

}
