package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 品鉴顾问分页dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 11:14
 **/
@Data
@ApiModel(value = "TastingConsultantPageDto",description ="品鉴顾问分页查询dto" )
public class TastingConsultantPageDto extends TenantFlagOpDto {

    @ApiModelProperty("品鉴顾问编码")
    private String code;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("单位")
    private String company;

    @ApiModelProperty("职位")
    private String position;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateStartDate;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateEndDate;

    @ApiModelProperty("单位编码")
    private String orgCode;

    @ApiModelProperty("单位名称")
    private String orgName;

    @ApiModelProperty("单位类型")
    private String orgType;


}
