package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * 核销用户dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 16:27
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VerificationUserDto", description = "核销用户dto")
public class VerificationUserDto extends TenantFlagOpDto {

    @ApiModelProperty("核销人员编码")
    private String userCode;

    @ApiModelProperty("核销人员姓名")
    private String userName;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("人员类型,数据字典:mms_verification_user_type 枚举:VerificationUserTypeEnum")
    private String userType;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;
}
