package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 轮播图信息dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 10:04
 **/
@Data
@ApiModel(value = "ViewpagerDto",description = "轮播图信息dto")
public class ViewpagerDto extends TenantFlagOpDto {

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("序号")
    private Integer sortIndex;

    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty("应用区域,数据字典:mms_use_area,枚举:UseAreaEnum")
    private String useArea;

    @ApiModelProperty("应用区域")
    private String useAreaName = StringUtils.EMPTY;

    @ApiModelProperty("跳转,数据字典:mms_skip_type,枚举:UseAreaEnum")
    private String skipType;

    @ApiModelProperty("跳转")
    private String skipTypeName = StringUtils.EMPTY;

    @ApiModelProperty("跳转url")
    private String skipUrl;

    @ApiModelProperty("小程序id")
    private String appId;

    @ApiModelProperty("主图")
    private String mainFileCode;



//    @ApiModelProperty("文件")
//    private List<ViewpagerFileDto> files;

}
