package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

/**
 * 轮播图片dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 10:01
 **/
@Getter
@Setter
@ApiModel(value = "ViewpagerFileDto", description = "轮播图片dto")
public class ViewpagerFileDto extends TenantFlagOpDto {

    @ApiModelProperty("轮播图主信息编码")
    private String viewpagerCode;

    /** 相对路径 */
    @ApiModelProperty("相对路径")
    private String relativePath = StringUtils.EMPTY;

    /** 文件名 */
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @ApiModelProperty("文件名")
    private String fileName;

    /** 图片类型 */
    @ApiModelProperty("图片类型")
    private String type;

    /** 是主图 */
    @ApiModelProperty("是主图")
    @JsonProperty(value = "mainImage")
    private Boolean mainImage;

    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex = 1;
}
