package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 *@description: 活动对用户的状态
*@Time:2023/6/28 9:17
*/
public enum ActivityForUserEnum {
  //字典类型编码mms_activity_for_user
  NO_JOIN("0","未报名"),
  HAS_JOIN("1","已报名"),
  JOIN_AGAIN("2","重新报名"),
  FULL_JOIN("3","报名已满"),
  WAIT_SIGN("4","待签到"),
  SCANNING_SIGN("5","扫码签到"),
  JOIN_NOW("6","立即报名"),
  HAS_SIGN("7","已签到"),
  NO_START("8","即将开始"),
  COMMITTING("9","等待审批"),
  ONLY_FOR_GOLD("10","仅黑金会员可报名"),
  THE_END("11","已结束"),
  MISS("12","错失报名机会"),
  COMPLETE("13","已参与"),
  NO_SIGN("14","未签到");

  @EnumValue
  @JsonValue
  private String code;
  private String des;

  ActivityForUserEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }
}
