package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 活动状态
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 17:22
 **/
public enum ActivityStatusEnum {

    //字典编码类型 mms_activity_status
    NOT_START("0","未开始"),
    APPLY_ING("1","报名中"),
    WAIT_SIGN("2","待签到"),
    SIGN_ING("3","签到中"),
    END("4","已结束"),
    DOING("5","进行中");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ActivityStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ActivityStatusEnum shelfStatusEnum : ActivityStatusEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ActivityStatusEnum codeToEnum(String code) {
        ActivityStatusEnum statusEnum = null;
        for (ActivityStatusEnum shelfStatusEnum : ActivityStatusEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ActivityStatusEnum[] values = ActivityStatusEnum.values();
            for (ActivityStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ActivityStatusEnum[] values = ActivityStatusEnum.values();
        for (ActivityStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
