package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/30 10:13
 * @description 小程序虚拟订单状态,数据字典: mms_app_dummy_order_status
 */
@Getter
public enum AppDummyOrderStatusEnum {
  ALL("all","全部"),
  STAY_USE("stay_use", "待核销"),
  HAS_WRITE_OFF("has_write_off", "已核销"),
  HAS_EXPIRED("has_expired", "已过期"),
  TO_EXPIRED("to_expired", "即将过期");

  private String value;
  private String desc;

  AppDummyOrderStatusEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (AppDummyOrderStatusEnum o : AppDummyOrderStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (AppDummyOrderStatusEnum o : AppDummyOrderStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    AppDummyOrderStatusEnum[] types = AppDummyOrderStatusEnum.values();
    for(AppDummyOrderStatusEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }

}
