package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/30 10:28
 * @description 小程序实物订单状态,数据字典:mms_app_real_order_status
 */
@Getter
public enum AppRealOrderStatusEnum {

  ALL("all", "全部"),
  STAY_SHIP("stay_ship", "待发货"),
  HAS_SHIP("has_ship", "已发货"),
  HAS_WRITE_OFF("has_write_off", "已核销");

  private String value;
  private String desc;

  AppRealOrderStatusEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (AppRealOrderStatusEnum o : AppRealOrderStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (AppRealOrderStatusEnum o : AppRealOrderStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    AppRealOrderStatusEnum[] types = AppRealOrderStatusEnum.values();
    for(AppRealOrderStatusEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
