package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 报名配置组件
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 13:52
 **/
public enum ApplyConfigItemEnum {

    NAME("NAME","姓名"),
    SEX("SEX","性别"),
    CONTANCT("CONTANCT","联系方式"),
    NORMALTEXT("NORMALTEXT","普通填空"),
    MULTITEXT("MULTITEXT","多行填空"),
    SINGLE("SINGLE","单选"),
    MORE("MORE","多选");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ApplyConfigItemEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ApplyConfigItemEnum shelfStatusEnum : ApplyConfigItemEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ApplyConfigItemEnum codeToEnum(String code) {
        ApplyConfigItemEnum statusEnum = null;
        for (ApplyConfigItemEnum shelfStatusEnum : ApplyConfigItemEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ApplyConfigItemEnum[] values = ApplyConfigItemEnum.values();
            for (ApplyConfigItemEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ApplyConfigItemEnum[] values = ApplyConfigItemEnum.values();
        for (ApplyConfigItemEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
