package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 报名审批状态码
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 17:12
 **/
public enum ApprovalStatusEnum {

    WAIT("0","待审批"),
    ING("1","审批中"),
    BACK("2","已驳回"),
    PASS("3","审批通过");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ApprovalStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ApprovalStatusEnum shelfStatusEnum : ApprovalStatusEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ApprovalStatusEnum codeToEnum(String code) {
        ApprovalStatusEnum statusEnum = null;
        for (ApprovalStatusEnum shelfStatusEnum : ApprovalStatusEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ApprovalStatusEnum[] values = ApprovalStatusEnum.values();
            for (ApprovalStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ApprovalStatusEnum[] values = ApprovalStatusEnum.values();
        for (ApprovalStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
