package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 权益类型
 */
@Getter
public enum BenefitsTypeEnum {
    DUMMY("dummy", "虚拟"),
    REAL("real", "实物"),
    WINE("wine", "酒卡");

    private String value;
    private String desc;

    BenefitsTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (BenefitsTypeEnum o : BenefitsTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (BenefitsTypeEnum o : BenefitsTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        BenefitsTypeEnum[] types = BenefitsTypeEnum.values();
        for(BenefitsTypeEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
