package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 权益单位
 */
@Getter
public enum BenefitsUnitEnum {
    BOTTLE("bottle", "瓶"),
    PIECE("piece", "个"),
    SHEET("sheet", "张"),
    BOX("box", "箱");

    private String value;
    private String desc;

    BenefitsUnitEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (BenefitsUnitEnum o : BenefitsUnitEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (BenefitsUnitEnum o : BenefitsUnitEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        BenefitsUnitEnum[] types = BenefitsUnitEnum.values();
        for(BenefitsUnitEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
