package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @Project crm-cps-server
 * @PackageName enums
 * @ClassName CpsYesOrNoEnum
 * @Author lgq
 * @Date 2022/8/25 17:57
 * @Description cps 公共是否
 */
@Getter
public enum CpsYesOrNoEnum {
    YES("Y", "是"),
    NO("N", "否"),;

    private String value;
    private String desc;

    CpsYesOrNoEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (CpsYesOrNoEnum o : CpsYesOrNoEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (CpsYesOrNoEnum o : CpsYesOrNoEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        CpsYesOrNoEnum[] types = CpsYesOrNoEnum.values();
        for(CpsYesOrNoEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
