package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 权益发放频次枚举类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 11:32
 **/
public enum DeliveryFrequencyEnum {

    MONTH("month","按月"),
    SEASON("season","按季"),
    YEAR("year","按年");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    DeliveryFrequencyEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (DeliveryFrequencyEnum deliveryFrequencyEnum : DeliveryFrequencyEnum.values()) {
            codes.add(deliveryFrequencyEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static DeliveryFrequencyEnum codeToEnum(String code) {
        DeliveryFrequencyEnum frequencyEnum = null;
        for (DeliveryFrequencyEnum deliveryFrequencyEnum : DeliveryFrequencyEnum.values()) {
            if (deliveryFrequencyEnum.code.equals(code)) {
                frequencyEnum = deliveryFrequencyEnum;
            }
        }
        return frequencyEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            DeliveryFrequencyEnum[] values = DeliveryFrequencyEnum.values();
            for (DeliveryFrequencyEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        DeliveryFrequencyEnum[] values = DeliveryFrequencyEnum.values();
        for (DeliveryFrequencyEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
