package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 虚拟订单状态
 */
@Getter
public enum DummyOrderStatusEnum {
    STAY_USE("stay_use", "待核销"),
    HAS_USE("has_use", "已使用"),
    HAS_WRITE_OFF("has_write_off", "已核销"),
    HAS_EXPIRED("has_expired", "已过期"),
    TO_EXPIRED("to_expired", "即将过期");

    private String value;
    private String desc;

    DummyOrderStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (DummyOrderStatusEnum o : DummyOrderStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (DummyOrderStatusEnum o : DummyOrderStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        DummyOrderStatusEnum[] types = DummyOrderStatusEnum.values();
        for(DummyOrderStatusEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
