package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/27 15:17
 **/
public enum EmployStatusEnum {

    NO_USE("0","未使用"),
    USED("1","已使用"),
    EXPIRE("3","已过期");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    EmployStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (EmployStatusEnum deliveryFrequencyEnum : EmployStatusEnum.values()) {
            codes.add(deliveryFrequencyEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static EmployStatusEnum codeToEnum(String code) {
        EmployStatusEnum frequencyEnum = null;
        for (EmployStatusEnum deliveryFrequencyEnum : EmployStatusEnum.values()) {
            if (deliveryFrequencyEnum.code.equals(code)) {
                frequencyEnum = deliveryFrequencyEnum;
            }
        }
        return frequencyEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            EmployStatusEnum[] values = EmployStatusEnum.values();
            for (EmployStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        EmployStatusEnum[] values = EmployStatusEnum.values();
        for (EmployStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
