package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 数据字典:mms_grow_operation
 *
 * @author hupan
 * @date 2023/6/30 16:53
 */
@Getter
public enum GrowOperationEnum {

  INCREASE("increase", "增加"),
  REDUCE("reduce", "减少");

  private String value;
  private String desc;

  GrowOperationEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public static Boolean isExist(String value) {
    for (GrowOperationEnum o : GrowOperationEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return true;
      }
    }
    return false;
  }

  public static String getDescByValue(String value) {
    for (GrowOperationEnum o : GrowOperationEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   *
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if (StringUtils.isBlank(code)) {
      return "未知";
    }
    GrowOperationEnum[] types = GrowOperationEnum.values();
    for (GrowOperationEnum type : types) {
      if (type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
