package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 数据字典:mms_grow_resource
 *
 * @author hupan
 * @date 2023/6/30 14:01
 */
@Getter
public enum GrowResourceEnum {

  SIGN("sign", "团购签收"),
  RETURN("return", "团购退货"),
  EXPIRATION("expiration_of_membership", "会籍过期"),
  SYSTEM_OPERATION("system_operation","系统操作");

  private String value;
  private String desc;

  GrowResourceEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public static Boolean isExist(String value) {
    for (GrowResourceEnum o : GrowResourceEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return true;
      }
    }
    return false;
  }

  public static String getDescByValue(String value) {
    for (GrowResourceEnum o : GrowResourceEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   *
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if (StringUtils.isBlank(code)) {
      return "未知";
    }
    GrowResourceEnum[] types = GrowResourceEnum.values();
    for (GrowResourceEnum type : types) {
      if (type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
