package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * mms_member_integral_source
 *
 * 积分来源
 */
@Getter
public enum IntegralSourceEnum {
    DAY_SIGN("day_sign", "每日签到","add","收入"),
    GROUP_BUY_RECEIPT("group_buy_receipt", "团购签收","add","收入"),
    BIG_TURNTABLE("big_turntable", "大转盘","add","收入"),
    CULTURAL_TOURISM_TOPIC("cultural_tourism_topic", "文旅答题","add","收入"),
    QUESTIONNAIRE("questionnaire", "问卷调查","add","收入"),
    SYS_ADD("sys_add", "系统增加","add","收入"),
    BIG_TURNTABLE_PAY("big_turntable_pay", "大转盘支出","pay","支出"),
    PRODUCT_EXCHANGE("product_exchange", "产品兑换","pay","支出"),
    GROUP_BUY_RETREAT("group_buy_retreat", "团购退货","deduction","扣减"),
    INTEGRAL_EXPIRED("integral_expired", "积分过期","deduction","扣减"),
    SYS_DEDUCTION("sys_deduction", "系统扣除","deduction","扣减");

    private String value;
    private String desc;
    private String type;
    private String typeDesc;

    IntegralSourceEnum(String value, String desc, String type, String typeDesc) {
        this.value = value;
        this.desc = desc;
        this.type = type;
        this.typeDesc = typeDesc;
    }

    public static Boolean isExist(String value){
        for (IntegralSourceEnum o : IntegralSourceEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }

    public static Boolean isExistType(String type){
        for (IntegralSourceEnum o : IntegralSourceEnum.values()) {
            if(StringUtils.equals(o.getType(),type)){
                return true;
            }
        }
        return false;
    }

    public static String getDescByValue(String value){
        for (IntegralSourceEnum o : IntegralSourceEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        IntegralSourceEnum[] types = IntegralSourceEnum.values();
        for(IntegralSourceEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
