package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author hupan
 * @date 2023/6/14 16:25
 */
@Getter
public enum LabelDetailEnum {
  ACCUMULATE_TIMES("accumulate_times", "累计签到次数"),
  ACCUMULATE_GROWTH("accumulate_growth", "累计成长值"),
  ACCUMULATE_POINTS("accumulate_points","累计积分"),
  CURRENT_GROWTH("current_growth","当前成长值"),
  LAST_SIGN_DAY("last_sign_day","最近签收时间"),
  CONTINUOUS_YEAR("continuous_year","连续会员等级"),
  CURRENT_POINTS("current_points","当前积分");

  private String value;
  private String desc;

  LabelDetailEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (BenefitsTypeEnum o : BenefitsTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (BenefitsTypeEnum o : BenefitsTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    BenefitsTypeEnum[] types = BenefitsTypeEnum.values();
    for(BenefitsTypeEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
